---
--- Generated by Luanalysis
--- Created by binghong.shen.
--- DateTime: 2022/5/6 15:52
---
--[[======================================
||	filename:       DesertEnergySpark
||	owner:          binghong.shen
||	description:    元能火种
||	LogName:        DesertEnergySpark
||	Protection:     [Protection]
=======================================]]

local fireTable = {
	[1]={fireID = defs.gadget_fire1,fireBaseID = defs.gadget_fireBase1},
	[2]={fireID = defs.gadget_fire2,fireBaseID = defs.gadget_fireBase2},
	[3]={fireID = defs.gadget_fire3,fireBaseID = defs.gadget_fireBase3},
	[4]={fireID = defs.gadget_fire4,fireBaseID = defs.gadget_fireBase4},

}

local extraTriggers={
	
	{ config_id = 8000002, name = "Select_Option", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "", action = "action_SelectOption", trigger_count = 0 },
	{ config_id = 8000003, name = "Fire_Reach_Point", event= EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "", action = "action_PlatReachPoint", trigger_count = 0 },
	{ config_id = 8000004, name = "Gadget_Create", event= EventType.EVENT_GADGET_CREATE, source = "", condition = "", action = "action_OnGadgetCreate", trigger_count = 0 },
	{ config_id = 8000005, name = "Gadget_Die", event= EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "", action = "action_OnAnyGadgetDie", trigger_count = 0 },
	{ config_id = 8000006, name = "Avatar_Near_Platform", event= EventType.EVENT_AVATAR_NEAR_PLATFORM, source = "", condition = "", action = "action_AvatarNearPlatform", trigger_count = 0 },
	{ config_id = 8000007, name = "GadgetStateChange", event= EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "", action = "action_GadgetStateChange", trigger_count = 0 },
	{ config_id = 8000008, name = "OnGroupLoad", event= EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_OnGroupLoad", trigger_count = 0 },

}
function action_OnGroupLoad(context)
	for _,v in pairs(fireTable) do
		if(v.fireID and v.fireID~=0)then
			ScriptLib.KillEntityByConfigId(context, { config_id = v.fireID })
		end
	end
	local moveIndex = ScriptLib.GetGroupVariableValue(context, "recordMoveIndex")

	for k,v in pairs(fireTable) do
		if(v.fireBaseID and v.fireBaseID~=0)then
			local baseState = ScriptLib.GetGadgetStateByConfigId(context, base_info.group_id, v.fireBaseID)
			if(baseState == 0 or baseState == 201)then
				if(k==moveIndex)then
					ScriptLib.SetGadgetStateByConfigId(context,v.fireBaseID , 201)
				else
					ScriptLib.SetGadgetStateByConfigId(context,v.fireBaseID , 0)
				end
			end
		end
	end
	return 0
end

function SLC_EngineerMark( context )

	local eid = context.source_entity_id

	ScriptLib.MarkGroupLuaAction(context, "getengineer", "", {group_id = base_info.group_id ,config_id = ScriptLib.GetGadgetConfigId(context, { gadget_eid = eid }) })

	return 0
end


function LF_Initialize_Group(triggers, suites)
	for i=1,#extraTriggers do
		table.insert(triggers, extraTriggers[i])
		table.insert(suites[init_config.suite].triggers,extraTriggers[i].name)
	end
	--初始化
	table.insert(variables,{  config_id=50000001,name = "recordMoveIndex", value = 1 , no_refresh = true})
end

--初始化一些按键
function action_OnGadgetCreate(context,evt )
	-- 设置操作台选项
	local isFireBase = false
	local gadgetID = evt.param1
	for _,v in pairs(fireTable) do
		if(v.fireBaseID==gadgetID)then
			isFireBase = true
			break
		end
	end

	if(isFireBase == false)then
		return -1
	end

	if GadgetState.GearStart == ScriptLib.GetGadgetStateByConfigId(context, base_info.group_id, gadgetID) then

		ScriptLib.PrintContextLog(context, "@@ DesertEnergySpark : energySpark SetOption")
		ScriptLib.SetWorktopOptionsByGroupId(context, base_info.group_id, gadgetID, {defs.interactOptionID})

	else
		ScriptLib.SetWorktopOptionsByGroupId(context, base_info.group_id, gadgetID, {})
	end

	return 0
end

--基座状态改变需要增删按钮
function action_GadgetStateChange( context,evt )
	local isFireBase = false
	local gadgetState = evt.param1
	local gadgetID = evt.param2
	for _,v in pairs(fireTable) do
		if(v.fireBaseID==gadgetID)then
			isFireBase = true
			break
		end
	end

	if(isFireBase == false)then
		return -1
	end

	if GadgetState.GearStart == gadgetState then
		ScriptLib.PrintContextLog(context, "@@ DesertEnergySpark : energySpark SetOption")
		ScriptLib.SetWorktopOptionsByGroupId(context, base_info.group_id, gadgetID, {defs.interactOptionID})
	else
		ScriptLib.SetWorktopOptionsByGroupId(context, base_info.group_id, gadgetID, {})
	end

	return 0
end
--按下按键召唤火种
function action_SelectOption( context,evt )
	local gadgetID = evt.param1
	local optionID = evt.param2
	if(optionID ~= defs.interactOptionID)then
		return -1
	end
	local moveIndex = 1
	for k,v in ipairs(fireTable)do
		if(v.fireBaseID==gadgetID)then
			moveIndex = k
			break
		end
	end


	local nextIndex = moveIndex + 1
	local nextFireBase = 0
	if(fireTable[nextIndex]~=nil and fireTable[nextIndex].fireBaseID~=0)then
		nextFireBase = fireTable[nextIndex].fireBaseID
		local entityID = ScriptLib.GetEntityIdByConfigId(context, nextFireBase)

		if ScriptLib.GetGadgetIdByEntityId(context, entityID) == 70330313 then
			local nextGadgetState = ScriptLib.GetGadgetStateByConfigId(context, base_info.group_id, nextFireBase)
			if nextGadgetState == 204 then
				ScriptLib.ShowReminder(context, 33010249)
				return 0
			end
		end
	end



	--ScriptLib.SetGroupTempValue(context, "CurMoveIndex", moveIndex, {})
	ScriptLib.SetGadgetStateByConfigId(context, fireTable[moveIndex].fireBaseID, 0)
	ScriptLib.SetWorktopOptionsByGroupId(context, base_info.group_id, gadgetID, {})
	ScriptLib.CreateGadget(context, { config_id = fireTable[moveIndex].fireID })

	return 0
end

--角色靠近火种能推动它
function action_AvatarNearPlatform( context,evt )
	local gadgetID = evt.param1

	--判断是否是火种
	local moveIndex = -1
	for k,v in ipairs(fireTable)do
		if(v.fireID==gadgetID)then
			moveIndex = k
			break
		end
	end
	if(moveIndex==-1)then
		return -1
	end

	ScriptLib.StartPlatform(context, gadgetID)
	return 0
end

--火种被风扇吹散
function action_OnAnyGadgetDie( context,evt )
	local gadgetID = evt.param1

	--判断是否是火种
	local moveIndex = -1
	for k,v in ipairs(fireTable)do
		if(v.fireID==gadgetID)then
			moveIndex = k
			break
		end
	end
	if(moveIndex==-1)then
		return -1
	end

	local nextIndex = moveIndex + 1
	local nextFireBase = 0
	if(fireTable[nextIndex]==nil or fireTable[nextIndex].fireBaseID==0)then
		nextFireBase = defs.gadget_fireTorch
	else
		nextFireBase = fireTable[nextIndex].fireBaseID
	end
	local gadgetState = ScriptLib.GetGadgetStateByConfigId(context, base_info.group_id, nextFireBase)
	--下一个gadget还没被点亮，所以是被风吹灭的，需要把上一个基座恢复
	if(gadgetState==0)then
		ScriptLib.SetGadgetStateByConfigId(context, fireTable[moveIndex].fireBaseID, 201)
	end

	return 0
end

--火种到达目的地
function action_PlatReachPoint( context,evt )
	local gadgetID = evt.param1
	local moveIndex = -1
	for k,v in ipairs(fireTable)do
		if(v.fireID==gadgetID)then
			moveIndex = k
			break
		end
	end
	if(moveIndex==-1)then
		return -1
	end
	local nextIndex = moveIndex+1
	if(fireTable[nextIndex]==nil or fireTable[nextIndex].fireBaseID==0)then
		--到达了终点
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_fireTorch, 201)
		ScriptLib.SetGadgetStateByConfigId(context,gadgetID , 201)
	else
		ScriptLib.SetGadgetStateByConfigId(context,fireTable[nextIndex].fireBaseID , 201)
		ScriptLib.KillEntityByConfigId(context, { config_id = gadgetID })
	end
	ScriptLib.SetGroupVariableValue(context, "recordMoveIndex", nextIndex)


	return 0
end


LF_Initialize_Group(triggers, suites)

