---
--- Generated by Luanalysis
--- Created by binghong.shen_187191.
--- DateTime: 2022/6/7 14:36
---
--[[======================================
||	filename:       DeshretElevator
||	owner:          binghong.shen
||	description:    赤王庙电梯
||	LogName:        DeshretElevator
||	Protection:     [Protection]
=======================================]]
--[[
defs.elevatorOptionID
defs.gadget_elevatorID
defs.finalMovePoints
--]]
---
local extrTriggers = {
	initialtrigger = {
		{ config_id = 80000001, name = "OnWorkOptionSelect", event= EventType.EVENT_SELECT_OPTION, source = "", condition = "", action = "action_OnWorkOptionSelect", trigger_count = 0},
		{ config_id = 80000002, name = "OnPlatformReach", event= EventType.EVENT_PLATFORM_ARRIVAL, source = "", condition = "", action = "action_OnPlatformReach", trigger_count = 0},
		{ config_id = 80000004, name = "OnGroupLoad", event = EventType.EVENT_GROUP_LOAD, source = "", condition = "", action = "action_OnGroupLoad", trigger_count = 0},

	}
}

function action_OnGroupLoad(context, evt)
	ScriptLib.PrintContextLog(context, "@@ DeshretElevator : elevator action_OnGroupLoad")

	local curMovePoint = ScriptLib.GetGroupVariableValue(context, "CurMovePoint")
	local pointArrayID = ScriptLib.GetGroupVariableValue(context, "pointarray_ID")
	ScriptLib.SetPlatformPointArray(context, defs.gadget_elevatorID, pointArrayID, {curMovePoint}, { route_type = 0,record_mode=1 })
	local isBlockMoveMode = ScriptLib.GetGroupVariableValue(context, "IsBlockMoveMode")
	if isBlockMoveMode == 1 then
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 203)
	else
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 201)
	end
	return 0
end

function action_OnWorkOptionSelect(context, evt)
	ScriptLib.PrintContextLog(context, "@@ DeshretElevator : elevator action_OnWorkOptionSelect")

	local optionID = evt.param2
	if(optionID == defs.elevatorOptionID)then
		local curMovePoint = ScriptLib.GetGroupVariableValue(context, "CurMovePoint")
		local movePoint1 = ScriptLib.GetGroupVariableValue(context, "MovePoint1")
		local movePoint2 = ScriptLib.GetGroupVariableValue(context, "MovePoint2")

		local toMovePoint = 0
		if(movePoint1==curMovePoint)then
			toMovePoint = movePoint2
		else
			toMovePoint = movePoint1
		end
		TryMoveElevatorToPoint(context,toMovePoint)
	end
	return 0

end

function SetElevator(context,PointArray,Point)
	ScriptLib.SetGroupVariableValue(context, "pointarray_ID",PointArray)
	ScriptLib.SetGroupVariableValue(context, "IsFinalMove",0)
	ScriptLib.SetGroupVariableValue(context, "CurMovePoint",Point)
	ScriptLib.SetGroupVariableValue(context, "MovePoint1",1)
	ScriptLib.SetGroupVariableValue(context, "MovePoint2",2)
	ScriptLib.StopPlatform(context, defs.gadget_elevatorID)
	ScriptLib.SetPlatformPointArray(context, defs.gadget_elevatorID, PointArray, {Point}, { route_type = 0,record_mode=1 })
	local isBlockMoveMode = ScriptLib.GetGroupVariableValue(context, "IsBlockMoveMode")
	if isBlockMoveMode == 1 then
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 203)
	else
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 201)
	end
	return 0
end


function SetElevator_finalMove(context,PointArray,StartPoint)
	ScriptLib.SetGroupVariableValue(context, "pointarray_ID",PointArray)
	ScriptLib.SetGroupVariableValue(context, "IsFinalMove",1)
	ScriptLib.SetGroupVariableValue(context, "CurMovePoint",StartPoint)
	ScriptLib.SetGroupVariableValue(context, "MovePoint1",defs.finalMovePoints[1])
	ScriptLib.SetGroupVariableValue(context, "MovePoint2",defs.finalMovePoints[#defs.finalMovePoints])
	ScriptLib.StopPlatform(context, defs.gadget_elevatorID)
	ScriptLib.SetPlatformPointArray(context, defs.gadget_elevatorID, PointArray, {StartPoint}, { route_type = 0,record_mode=1 })
	local isBlockMoveMode = ScriptLib.GetGroupVariableValue(context, "IsBlockMoveMode")
	if isBlockMoveMode == 1 then
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 203)
	else
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 201)
	end
	return 0
end

function TryMoveElevatorToPoint(context,Point)
	ScriptLib.PrintContextLog(context, "@@ DeshretElevator : elevator TryMoveElevatorToPoint "..Point)

	local curMovePoint = ScriptLib.GetGroupVariableValue(context, "CurMovePoint")
	if(curMovePoint==Point)then
		ScriptLib.ShowReminder(context, 400191)
		return 0
	end
	local pointArrayID = ScriptLib.GetGroupVariableValue(context, "pointarray_ID")
	ScriptLib.PrintContextLog(context, "@@ DeshretElevator : elevator pointArrayID "..pointArrayID)

	--先停再移动
	ScriptLib.StopPlatform(context, defs.gadget_elevatorID)
	local IsFinalMove = ScriptLib.GetGroupVariableValue(context, "IsFinalMove")
	if IsFinalMove == 1 then
		local movePoints = {}
		if(defs.finalMovePoints[1]==Point)then
			for i = #defs.finalMovePoints,1,-1 do
				table.insert(movePoints,defs.finalMovePoints[i])
			end
		else
			movePoints = defs.finalMovePoints
		end
		ScriptLib.SetPlatformPointArray(context, defs.gadget_elevatorID, pointArrayID, movePoints, { route_type = 0,record_mode=1 })
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 203)
	else
		ScriptLib.SetPlatformPointArray(context, defs.gadget_elevatorID, pointArrayID, {Point}, { route_type = 0,record_mode=1 })
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 201)
	end
	ScriptLib.SetGroupVariableValue(context, "CurMovePoint",Point)

	return 0

end

function action_OnPlatformReach(context, evt)
	ScriptLib.PrintContextLog(context, "@@ DeshretElevator : elevator action_OnPlatformReach")

	local config_id = evt.param1
	local reachPoint = evt.param3
	local curMovePoint = ScriptLib.GetGroupVariableValue(context, "CurMovePoint")

	if(config_id == defs.gadget_elevatorID and reachPoint == curMovePoint)then
		ScriptLib.SetGadgetStateByConfigId(context, defs.gadget_elevatorID, 0)
	end
	return 0

end

function SLC_DeshretElevatorUpdate(context, value)
	ScriptLib.PrintContextLog(context, "@@ DeshretElevator : elevator SLC_DeshretElevatorUpdate")

	local gadgetID = ScriptLib.GetGadgetConfigId(context, {gadget_eid = context.source_entity_id})

	if(value == 0)then
		ScriptLib.SetWorktopOptionsByGroupId(context, base_info.group_id, gadgetID, {defs.elevatorOptionID})
	else
		ScriptLib.SetWorktopOptionsByGroupId(context, base_info.group_id, gadgetID, {})
	end
	return 0

end

function LF_Initialize_Group()
	for _,v in pairs(extrTriggers.initialtrigger) do
		table.insert(triggers, v)
		table.insert(suites[init_config.suite].triggers, v.name)
	end
	--table.insert(variables,{  config_id=50000001,name = "CurMovePoint", value = 1 })
	--table.insert(variables,{  config_id=50000002,name = "pointarray_ID", value = 1 })
	--table.insert(variables,{  config_id=50000003,name = "MovePoint1", value = 1 })
	--table.insert(variables,{  config_id=50000004,name = "MovePoint2", value = 2 })
	--table.insert(variables,{  config_id=50000005,name = "IsBlockMoveMode", value = 0 })
	--table.insert(variables,{  config_id=50000005,name = "IsFinalMove", value = 0 })

	return 0
end
LF_Initialize_Group()
