-- 基础信息
local base_info = {
	group_id = 111101097
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 97001, monster_id = 20011201, pos = { x = 2180.268, y = 226.158, z = -1218.638 }, rot = { x = 0.000, y = 154.794, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97003, monster_id = 20011201, pos = { x = 2178.016, y = 226.257, z = -1222.886 }, rot = { x = 0.000, y = 154.794, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97005, monster_id = 20011301, pos = { x = 2183.560, y = 227.496, z = -1223.656 }, rot = { x = 0.000, y = 199.772, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97009, monster_id = 20011101, pos = { x = 2178.307, y = 225.777, z = -1219.644 }, rot = { x = 0.000, y = 113.268, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97010, monster_id = 20011001, pos = { x = 2179.438, y = 226.871, z = -1224.318 }, rot = { x = 0.000, y = 113.268, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97011, monster_id = 20011001, pos = { x = 2184.098, y = 227.309, z = -1221.219 }, rot = { x = 0.000, y = 158.246, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97012, monster_id = 20010501, pos = { x = 2179.268, y = 226.967, z = -1224.980 }, rot = { x = 0.000, y = 279.020, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97013, monster_id = 20010501, pos = { x = 2178.991, y = 225.917, z = -1219.390 }, rot = { x = 0.000, y = 234.042, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97014, monster_id = 20010601, pos = { x = 2183.584, y = 227.187, z = -1220.810 }, rot = { x = 0.000, y = 234.042, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97017, monster_id = 20010901, pos = { x = 2180.463, y = 226.170, z = -1218.210 }, rot = { x = 0.000, y = 74.056, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97018, monster_id = 20010801, pos = { x = 2183.072, y = 227.358, z = -1223.159 }, rot = { x = 0.000, y = 29.078, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97019, monster_id = 20010801, pos = { x = 2178.307, y = 226.538, z = -1223.811 }, rot = { x = 0.000, y = 29.078, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97024, monster_id = 20011401, pos = { x = 2181.802, y = 227.428, z = -1225.045 }, rot = { x = 0.000, y = 236.865, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97025, monster_id = 20011501, pos = { x = 2177.843, y = 225.865, z = -1221.085 }, rot = { x = 0.000, y = 191.887, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } },
	{ config_id = 97026, monster_id = 20011401, pos = { x = 2182.201, y = 226.666, z = -1219.054 }, rot = { x = 0.000, y = 191.887, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 } }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 97002, gadget_id = 70690006, pos = { x = 2206.920, y = 272.854, z = -1212.204 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97004, gadget_id = 70310013, pos = { x = 2192.543, y = 283.620, z = -1229.954 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97007, gadget_id = 70690006, pos = { x = 2175.769, y = 224.837, z = -1214.379 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97008, gadget_id = 70360025, pos = { x = 2192.562, y = 284.331, z = -1229.872 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97015, gadget_id = 70350085, pos = { x = 2192.562, y = 284.331, z = -1229.872 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97016, gadget_id = 70690006, pos = { x = 2191.272, y = 252.554, z = -1196.376 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97020, gadget_id = 70690006, pos = { x = 2200.841, y = 239.446, z = -1220.121 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97030, gadget_id = 70360001, pos = { x = 2181.200, y = 226.854, z = -1222.291 }, rot = { x = 6.335, y = 28.693, z = 3.410 }, level = 1, persistent = true },
	{ config_id = 97031, gadget_id = 70350083, pos = { x = 2181.202, y = 226.880, z = -1222.416 }, rot = { x = 6.335, y = 28.693, z = 3.410 }, level = 1, persistent = true },
	{ config_id = 97034, gadget_id = 70310013, pos = { x = 2195.668, y = 239.446, z = -1218.892 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97035, gadget_id = 70310013, pos = { x = 2192.211, y = 252.570, z = -1201.733 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 },
	{ config_id = 97037, gadget_id = 70310013, pos = { x = 2206.138, y = 272.805, z = -1210.033 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1 }
}

-- 区域
regions = {
	{ config_id = 97023, shape = RegionShape.SPHERE, radius = 2, pos = { x = 2192.562, y = 283.942, z = -1229.872 } }
}

-- 触发器
triggers = {
	{ config_id = 1097006, name = "GADGET_CREATE_97006", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_97006", action = "action_EVENT_GADGET_CREATE_97006", trigger_count = 0 },
	{ config_id = 1097021, name = "CHALLENGE_SUCCESS_97021", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "874", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_97021", trigger_count = 0 },
	{ config_id = 1097022, name = "CHALLENGE_FAIL_97022", event = EventType.EVENT_CHALLENGE_FAIL, source = "874", condition = "", action = "action_EVENT_CHALLENGE_FAIL_97022", trigger_count = 0 },
	{ config_id = 1097023, name = "ENTER_REGION_97023", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_97023", action = "", trigger_count = 0, tag = "888" },
	{ config_id = 1097032, name = "SELECT_OPTION_97032", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_97032", action = "action_EVENT_SELECT_OPTION_97032", trigger_count = 0 }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 起点,
		monsters = { },
		gadgets = { 97030, 97031 },
		regions = { },
		triggers = { "GADGET_CREATE_97006", "CHALLENGE_SUCCESS_97021", "CHALLENGE_FAIL_97022", "SELECT_OPTION_97032" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 终点,
		monsters = { },
		gadgets = { 97002, 97004, 97007, 97008, 97015, 97016, 97020, 97034, 97035, 97037 },
		regions = { 97023 },
		triggers = { "ENTER_REGION_97023" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 事件完成空Suite,
		monsters = { },
		gadgets = { 97031 },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_CREATE_97006(context, evt)
	if 97030 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_97006(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 111101097, 97030, {40}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_97021(context, evt)
	-- 将configid为 97031 的物件更改为状态 GadgetState.GearStop
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 97031, GadgetState.GearStop) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 97008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 111101097, 2)
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 111101097, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	--销毁编号为1（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 111101097, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_97022(context, evt)
	-- 将configid为 97031 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 97031, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建id为97030的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 97030 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 97008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 111101097, 2)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	--销毁编号为1（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 111101097, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_97023(context, evt)
	if evt.param1 ~= 97023 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_97032(context, evt)
	-- 判断是gadgetid 97030 option_id 40
	if 97030 ~= evt.param1 then
		return false	
	end
	
	if 40 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_97032(context, evt)
	-- 删除指定group： 111101097 ；指定config：97030；物件身上指定option：40；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 111101097, 97030, 40) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 97030 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 97031 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 97031, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建编号为874（该挑战的识别id),挑战内容为205的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 874, 205, 30, 4, 888, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 111101097, 2)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 创建编号为1（该怪物潮的识别id)的怪物潮，创建怪物总数为15，场上怪物最少3只，最多3只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 1, 111101097, {97001,97003,97005,97011,97010,97009,97019,97018,97017,97013,97012,97014,97024,97026,97025}, 15, 3, 3) then
		return -1
	end
	
	return 0
end