-- 基础信息
local base_info = {
	group_id = 133004365
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 365001, gadget_id = 70690001, pos = { x = 2287.565, y = 311.344, z = -153.364 }, rot = { x = 1.093, y = 183.327, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365004, gadget_id = 70360094, pos = { x = 2287.565, y = 311.344, z = -153.364 }, rot = { x = 1.093, y = 183.326, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365005, gadget_id = 70690001, pos = { x = 2286.544, y = 311.008, z = -170.944 }, rot = { x = 354.627, y = 194.993, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365006, gadget_id = 70360094, pos = { x = 2287.820, y = 311.428, z = -148.985 }, rot = { x = 1.093, y = 183.326, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365007, gadget_id = 70360096, pos = { x = 2277.996, y = 316.376, z = -199.756 }, rot = { x = 1.656, y = 185.962, z = 0.000 }, level = 1, route_id = 300400658, area_id = 3 },
	{ config_id = 365008, gadget_id = 70360094, pos = { x = 2287.356, y = 311.275, z = -156.970 }, rot = { x = 1.093, y = 183.326, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365009, gadget_id = 70690001, pos = { x = 2276.197, y = 308.658, z = -229.323 }, rot = { x = 347.451, y = 181.061, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365010, gadget_id = 70360094, pos = { x = 2286.892, y = 311.123, z = -164.955 }, rot = { x = 1.093, y = 183.328, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365011, gadget_id = 70690016, pos = { x = 2267.565, y = 275.457, z = -294.725 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365013, gadget_id = 70360094, pos = { x = 2286.427, y = 310.970, z = -172.940 }, rot = { x = 3.124, y = 195.899, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365014, gadget_id = 70360094, pos = { x = 2284.249, y = 310.536, z = -180.588 }, rot = { x = 3.480, y = 198.191, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365015, gadget_id = 70360094, pos = { x = 2281.756, y = 310.050, z = -188.174 }, rot = { x = 3.480, y = 198.191, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365016, gadget_id = 70360094, pos = { x = 2279.263, y = 309.565, z = -195.760 }, rot = { x = 3.480, y = 198.191, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365017, gadget_id = 70360094, pos = { x = 2276.770, y = 309.079, z = -203.347 }, rot = { x = 1.002, y = 181.726, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365018, gadget_id = 70360094, pos = { x = 2276.530, y = 308.940, z = -211.328 }, rot = { x = 0.898, y = 181.060, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365019, gadget_id = 70360094, pos = { x = 2276.382, y = 308.814, z = -219.326 }, rot = { x = 0.898, y = 181.062, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365020, gadget_id = 70360094, pos = { x = 2276.234, y = 308.689, z = -227.323 }, rot = { x = 347.451, y = 181.060, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365021, gadget_id = 70360094, pos = { x = 2276.086, y = 308.564, z = -235.321 }, rot = { x = 0.898, y = 181.060, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365022, gadget_id = 70360094, pos = { x = 2275.938, y = 308.438, z = -243.318 }, rot = { x = 0.898, y = 181.060, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365023, gadget_id = 70360094, pos = { x = 2275.790, y = 308.313, z = -251.316 }, rot = { x = 1.547, y = 183.916, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365024, gadget_id = 70360094, pos = { x = 2275.244, y = 308.097, z = -259.290 }, rot = { x = 1.817, y = 185.108, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365025, gadget_id = 70360094, pos = { x = 2274.532, y = 307.843, z = -267.254 }, rot = { x = 1.817, y = 185.108, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365026, gadget_id = 70360094, pos = { x = 2273.820, y = 307.590, z = -275.219 }, rot = { x = 1.817, y = 185.108, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365027, gadget_id = 70360094, pos = { x = 2273.108, y = 307.336, z = -283.183 }, rot = { x = 1.817, y = 185.108, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365028, gadget_id = 70690001, pos = { x = 2268.287, y = 323.793, z = -314.400 }, rot = { x = 355.876, y = 180.861, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365029, gadget_id = 70360096, pos = { x = 2333.174, y = 336.385, z = -563.467 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, route_id = 300400660, area_id = 1 },
	{ config_id = 365030, gadget_id = 70690001, pos = { x = 2267.838, y = 325.951, z = -344.318 }, rot = { x = 356.018, y = 180.690, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365031, gadget_id = 70690001, pos = { x = 2267.658, y = 326.992, z = -359.279 }, rot = { x = 359.264, y = 176.811, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365032, gadget_id = 70690001, pos = { x = 2343.385, y = 335.753, z = -569.989 }, rot = { x = 357.340, y = 116.101, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365033, gadget_id = 70360096, pos = { x = 2269.373, y = 327.388, z = -390.050 }, rot = { x = 359.264, y = 176.811, z = 0.000 }, level = 1, route_id = 300400659, area_id = 3 },
	{ config_id = 365034, gadget_id = 70690001, pos = { x = 2270.161, y = 327.570, z = -404.205 }, rot = { x = 350.932, y = 169.316, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365035, gadget_id = 70900201, pos = { x = 2336.951, y = 210.054, z = -938.274 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365036, gadget_id = 70690001, pos = { x = 2276.044, y = 329.275, z = -433.546 }, rot = { x = 356.538, y = 168.010, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365037, gadget_id = 70690001, pos = { x = 2279.154, y = 330.181, z = -448.192 }, rot = { x = 346.716, y = 168.490, z = 1.531 }, level = 1, area_id = 3 },
	{ config_id = 365038, gadget_id = 70690001, pos = { x = 2370.297, y = 337.145, z = -583.174 }, rot = { x = 357.340, y = 116.101, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365039, gadget_id = 70690001, pos = { x = 2288.544, y = 330.140, z = -476.634 }, rot = { x = 354.885, y = 160.467, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365040, gadget_id = 70690001, pos = { x = 2293.559, y = 329.933, z = -490.770 }, rot = { x = 354.651, y = 157.666, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365041, gadget_id = 70690001, pos = { x = 2383.753, y = 337.842, z = -589.766 }, rot = { x = 1.731, y = 124.778, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365042, gadget_id = 70690001, pos = { x = 2305.810, y = 330.298, z = -518.107 }, rot = { x = 353.511, y = 154.059, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365043, gadget_id = 70690001, pos = { x = 2312.370, y = 330.634, z = -531.592 }, rot = { x = 354.304, y = 154.060, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365044, gadget_id = 70360025, pos = { x = 2337.679, y = 209.937, z = -938.526 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365045, gadget_id = 70690001, pos = { x = 2325.490, y = 331.304, z = -558.563 }, rot = { x = 358.719, y = 154.059, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365047, gadget_id = 70360095, pos = { x = 2267.913, y = 325.591, z = -339.332 }, rot = { x = 356.638, y = 179.947, z = 0.000 }, level = 1, route_id = 300400629, area_id = 3 },
	{ config_id = 365048, gadget_id = 70360095, pos = { x = 2268.927, y = 327.285, z = -382.056 }, rot = { x = 359.264, y = 176.811, z = 0.000 }, level = 1, route_id = 300400630, area_id = 3 },
	{ config_id = 365049, gadget_id = 70360095, pos = { x = 2273.577, y = 328.519, z = -430.222 }, rot = { x = 358.413, y = 174.080, z = 0.000 }, level = 1, route_id = 300400631, area_id = 3 },
	{ config_id = 365051, gadget_id = 70360093, pos = { x = 2285.124, y = 330.538, z = -468.449 }, rot = { x = 358.230, y = 165.001, z = 0.000 }, level = 1, route_id = 300400632, area_id = 3 },
	{ config_id = 365052, gadget_id = 70690016, pos = { x = 2287.959, y = 264.146, z = -136.389 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 15, area_id = 3 },
	{ config_id = 365054, gadget_id = 70360093, pos = { x = 2302.950, y = 330.152, z = -512.229 }, rot = { x = 358.719, y = 154.059, z = 0.000 }, level = 1, route_id = 300400633, area_id = 3 },
	{ config_id = 365055, gadget_id = 70360095, pos = { x = 2320.708, y = 331.060, z = -548.734 }, rot = { x = 358.719, y = 154.060, z = 0.000 }, level = 1, route_id = 300400634, area_id = 1 },
	{ config_id = 365056, gadget_id = 70360095, pos = { x = 2323.303, y = 331.192, z = -554.068 }, rot = { x = 358.719, y = 154.060, z = 0.000 }, level = 1, route_id = 300400635, area_id = 1 },
	{ config_id = 365057, gadget_id = 70360094, pos = { x = 2268.226, y = 324.087, z = -318.482 }, rot = { x = 355.876, y = 180.861, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365058, gadget_id = 70360094, pos = { x = 2268.139, y = 324.503, z = -324.251 }, rot = { x = 355.876, y = 180.861, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365059, gadget_id = 70360094, pos = { x = 2268.048, y = 324.944, z = -330.356 }, rot = { x = 355.876, y = 180.863, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365061, gadget_id = 70360094, pos = { x = 2267.808, y = 326.094, z = -346.313 }, rot = { x = 355.876, y = 180.861, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365062, gadget_id = 70360094, pos = { x = 2267.688, y = 326.670, z = -354.291 }, rot = { x = 357.413, y = 179.019, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365063, gadget_id = 70360094, pos = { x = 2267.825, y = 327.031, z = -362.274 }, rot = { x = 359.264, y = 176.811, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365064, gadget_id = 70360094, pos = { x = 2268.270, y = 327.133, z = -370.261 }, rot = { x = 359.265, y = 176.811, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365065, gadget_id = 70360094, pos = { x = 2268.715, y = 327.236, z = -378.248 }, rot = { x = 359.264, y = 176.811, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365066, gadget_id = 70360094, pos = { x = 2269.160, y = 327.339, z = -386.235 }, rot = { x = 359.265, y = 176.811, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365067, gadget_id = 70360094, pos = { x = 2269.605, y = 327.441, z = -394.221 }, rot = { x = 359.265, y = 176.811, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365068, gadget_id = 70360094, pos = { x = 2270.050, y = 327.544, z = -402.208 }, rot = { x = 357.972, y = 172.664, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365069, gadget_id = 70360094, pos = { x = 2271.067, y = 327.826, z = -410.112 }, rot = { x = 356.538, y = 168.010, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365070, gadget_id = 70360094, pos = { x = 2272.726, y = 328.309, z = -417.924 }, rot = { x = 356.538, y = 168.012, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365071, gadget_id = 70360094, pos = { x = 2274.385, y = 328.792, z = -425.735 }, rot = { x = 356.538, y = 168.012, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365072, gadget_id = 70360094, pos = { x = 2276.044, y = 329.275, z = -433.546 }, rot = { x = 356.538, y = 168.010, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365073, gadget_id = 70360094, pos = { x = 2277.703, y = 329.758, z = -441.357 }, rot = { x = 356.538, y = 168.012, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365074, gadget_id = 70360094, pos = { x = 2279.361, y = 330.241, z = -449.169 }, rot = { x = 345.966, y = 169.783, z = 1.247 }, level = 1, area_id = 3 },
	{ config_id = 365075, gadget_id = 70360094, pos = { x = 2281.524, y = 330.430, z = -456.845 }, rot = { x = 0.792, y = 160.467, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365076, gadget_id = 70360094, pos = { x = 2284.198, y = 330.320, z = -464.384 }, rot = { x = 0.792, y = 160.467, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365077, gadget_id = 70360094, pos = { x = 2286.873, y = 330.209, z = -471.922 }, rot = { x = 0.791, y = 160.467, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365078, gadget_id = 70360094, pos = { x = 2289.547, y = 330.099, z = -479.461 }, rot = { x = 0.791, y = 160.465, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365079, gadget_id = 70360094, pos = { x = 2292.222, y = 329.988, z = -487.000 }, rot = { x = 0.791, y = 160.467, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365080, gadget_id = 70360094, pos = { x = 2294.897, y = 329.878, z = -494.539 }, rot = { x = 359.870, y = 157.618, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365081, gadget_id = 70360094, pos = { x = 2297.938, y = 329.896, z = -501.924 }, rot = { x = 358.719, y = 154.060, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365082, gadget_id = 70360094, pos = { x = 2301.436, y = 330.075, z = -509.116 }, rot = { x = 358.719, y = 154.059, z = 0.000 }, level = 1, area_id = 3 },
	{ config_id = 365083, gadget_id = 70360094, pos = { x = 2304.935, y = 330.254, z = -516.309 }, rot = { x = 358.719, y = 154.060, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365084, gadget_id = 70360094, pos = { x = 2308.434, y = 330.432, z = -523.501 }, rot = { x = 358.719, y = 154.060, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365085, gadget_id = 70360094, pos = { x = 2311.932, y = 330.611, z = -530.693 }, rot = { x = 354.304, y = 154.058, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365086, gadget_id = 70360094, pos = { x = 2315.431, y = 330.790, z = -537.885 }, rot = { x = 358.719, y = 154.060, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365087, gadget_id = 70360094, pos = { x = 2318.929, y = 330.969, z = -545.078 }, rot = { x = 358.719, y = 154.059, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365089, gadget_id = 70360094, pos = { x = 2325.927, y = 331.326, z = -559.462 }, rot = { x = 358.719, y = 154.060, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365091, gadget_id = 70360095, pos = { x = 2395.429, y = 337.412, z = -597.874 }, rot = { x = 16.387, y = 156.813, z = 0.000 }, level = 1, route_id = 300400649, area_id = 1 },
	{ config_id = 365092, gadget_id = 70690001, pos = { x = 2416.543, y = 321.954, z = -651.465 }, rot = { x = 2.666, y = 172.563, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365093, gadget_id = 70690001, pos = { x = 2418.483, y = 321.256, z = -666.322 }, rot = { x = 2.667, y = 172.562, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365094, gadget_id = 70360095, pos = { x = 2406.350, y = 329.255, z = -623.370 }, rot = { x = 16.387, y = 156.813, z = 0.000 }, level = 1, route_id = 300400648, area_id = 1 },
	{ config_id = 365096, gadget_id = 70690001, pos = { x = 2424.185, y = 318.982, z = -710.848 }, rot = { x = 26.565, y = 188.211, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365097, gadget_id = 70360095, pos = { x = 2414.316, y = 323.306, z = -641.968 }, rot = { x = 4.742, y = 170.291, z = 0.000 }, level = 1, route_id = 300400647, area_id = 1 },
	{ config_id = 365100, gadget_id = 70360095, pos = { x = 2421.396, y = 320.208, z = -688.641 }, rot = { x = 2.667, y = 172.562, z = 0.000 }, level = 1, route_id = 300400646, area_id = 1 },
	{ config_id = 365101, gadget_id = 70360096, pos = { x = 2413.632, y = 287.496, z = -777.487 }, rot = { x = 359.579, y = 200.059, z = 0.000 }, level = 1, route_id = 300400661, area_id = 1 },
	{ config_id = 365102, gadget_id = 70690001, pos = { x = 2408.488, y = 287.606, z = -791.576 }, rot = { x = 359.579, y = 200.059, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365103, gadget_id = 70360095, pos = { x = 2421.716, y = 320.093, z = -691.085 }, rot = { x = 7.856, y = 175.671, z = 0.000 }, level = 1, route_id = 300400645, area_id = 1 },
	{ config_id = 365104, gadget_id = 70690001, pos = { x = 2398.198, y = 287.826, z = -819.756 }, rot = { x = 359.579, y = 200.059, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365105, gadget_id = 70690001, pos = { x = 2393.054, y = 287.937, z = -833.846 }, rot = { x = 359.579, y = 200.059, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365106, gadget_id = 70360095, pos = { x = 2421.756, y = 319.148, z = -727.685 }, rot = { x = 26.565, y = 188.211, z = 0.000 }, level = 1, route_id = 300400644, area_id = 1 },
	{ config_id = 365107, gadget_id = 70690001, pos = { x = 2382.764, y = 288.157, z = -862.025 }, rot = { x = 29.893, y = 207.193, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365108, gadget_id = 70690001, pos = { x = 2377.046, y = 280.963, z = -873.155 }, rot = { x = 37.560, y = 209.591, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365109, gadget_id = 70360095, pos = { x = 2420.353, y = 305.566, z = -737.406 }, rot = { x = 26.565, y = 188.211, z = 0.000 }, level = 1, route_id = 300400643, area_id = 1 },
	{ config_id = 365111, gadget_id = 70690001, pos = { x = 2365.302, y = 262.676, z = -893.835 }, rot = { x = 37.560, y = 209.592, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365113, gadget_id = 70360096, pos = { x = 2352.235, y = 242.326, z = -916.846 }, rot = { x = 37.560, y = 209.592, z = 0.000 }, level = 1, route_id = 300400662, area_id = 1 },
	{ config_id = 365114, gadget_id = 70360095, pos = { x = 2417.160, y = 294.385, z = -759.537 }, rot = { x = 16.427, y = 193.035, z = 0.000 }, level = 1, route_id = 300400642, area_id = 1 },
	{ config_id = 365116, gadget_id = 70360095, pos = { x = 2400.787, y = 287.771, z = -812.667 }, rot = { x = 359.579, y = 200.059, z = 0.000 }, level = 1, route_id = 300400641, area_id = 1 },
	{ config_id = 365117, gadget_id = 70360095, pos = { x = 2387.920, y = 288.046, z = -847.904 }, rot = { x = 359.579, y = 200.059, z = 0.000 }, level = 1, route_id = 300400636, area_id = 1 },
	{ config_id = 365118, gadget_id = 70360093, pos = { x = 2386.194, y = 288.083, z = -852.632 }, rot = { x = 17.582, y = 204.025, z = 0.000 }, level = 1, route_id = 300400640, area_id = 1 },
	{ config_id = 365119, gadget_id = 70360095, pos = { x = 2370.696, y = 271.076, z = -884.336 }, rot = { x = 37.560, y = 209.591, z = 0.000 }, level = 1, route_id = 300400637, area_id = 1 },
	{ config_id = 365120, gadget_id = 70360095, pos = { x = 2367.259, y = 265.724, z = -890.388 }, rot = { x = 37.560, y = 209.592, z = 0.000 }, level = 1, route_id = 300400639, area_id = 1 },
	{ config_id = 365121, gadget_id = 70360095, pos = { x = 2357.473, y = 250.484, z = -907.621 }, rot = { x = 37.560, y = 209.592, z = 0.000 }, level = 1, route_id = 300400638, area_id = 1 },
	{ config_id = 365123, gadget_id = 70690014, pos = { x = 2356.841, y = 336.449, z = -576.581 }, rot = { x = 357.340, y = 116.101, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365125, gadget_id = 70690014, pos = { x = 2401.095, y = 333.180, z = -611.102 }, rot = { x = 16.387, y = 156.813, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365126, gadget_id = 70690014, pos = { x = 2412.427, y = 324.716, z = -637.559 }, rot = { x = 6.714, y = 168.111, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365128, gadget_id = 70690014, pos = { x = 2422.352, y = 319.425, z = -699.148 }, rot = { x = 15.114, y = 180.189, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365129, gadget_id = 70690014, pos = { x = 2422.269, y = 312.274, z = -724.127 }, rot = { x = 26.565, y = 188.211, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365130, gadget_id = 70690014, pos = { x = 2418.437, y = 298.858, z = -750.685 }, rot = { x = 22.649, y = 190.164, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365132, gadget_id = 70690014, pos = { x = 2402.864, y = 287.726, z = -806.978 }, rot = { x = 359.579, y = 200.059, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365136, gadget_id = 70690014, pos = { x = 2359.430, y = 253.532, z = -904.175 }, rot = { x = 37.560, y = 209.592, z = 0.000 }, level = 1, area_id = 1 },
	{ config_id = 365142, gadget_id = 70360001, pos = { x = 2299.602, y = 300.087, z = -133.896 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 2, area_id = 3 },
	{ config_id = 365144, gadget_id = 70350083, pos = { x = 2299.598, y = 299.065, z = -133.859 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 2, area_id = 3 }
}

-- 区域
regions = {
	{ config_id = 365046, shape = RegionShape.SPHERE, radius = 37.4, pos = { x = 2420.109, y = 320.043, z = -682.107 }, area_id = 1 },
	{ config_id = 365050, shape = RegionShape.SPHERE, radius = 37.7, pos = { x = 2391.675, y = 287.456, z = -837.480 }, area_id = 1 },
	{ config_id = 365172, shape = RegionShape.SPHERE, radius = 5, pos = { x = 2336.279, y = 210.118, z = -938.262 }, area_id = 1 },
	{ config_id = 365173, shape = RegionShape.SPHERE, radius = 32.9, pos = { x = 2272.715, y = 311.201, z = -274.508 }, area_id = 3 },
	{ config_id = 365174, shape = RegionShape.SPHERE, radius = 42.5, pos = { x = 2343.009, y = 343.984, z = -554.897 }, area_id = 1 }
}

-- 触发器
triggers = {
	{ config_id = 1365002, name = "GADGET_CREATE_365002", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_365002", action = "action_EVENT_GADGET_CREATE_365002", trigger_count = 0 },
	{ config_id = 1365003, name = "SELECT_OPTION_365003", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_365003", action = "action_EVENT_SELECT_OPTION_365003", trigger_count = 0 },
	{ config_id = 1365046, name = "ENTER_REGION_365046", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_365046", action = "action_EVENT_ENTER_REGION_365046" },
	{ config_id = 1365050, name = "ENTER_REGION_365050", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_365050", action = "action_EVENT_ENTER_REGION_365050" },
	{ config_id = 1365110, name = "GADGET_STATE_CHANGE_365110", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_365110", action = "action_EVENT_GADGET_STATE_CHANGE_365110" },
	{ config_id = 1365143, name = "CHALLENGE_FAIL_365143", event = EventType.EVENT_CHALLENGE_FAIL, source = "2008", condition = "", action = "action_EVENT_CHALLENGE_FAIL_365143" },
	{ config_id = 1365145, name = "CHALLENGE_SUCCESS_365145", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "2008", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_365145" },
	{ config_id = 1365172, name = "ENTER_REGION_365172", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_365172", action = "", tag = "666" },
	{ config_id = 1365173, name = "ENTER_REGION_365173", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_365173", action = "action_EVENT_ENTER_REGION_365173" },
	{ config_id = 1365174, name = "ENTER_REGION_365174", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_365174", action = "action_EVENT_ENTER_REGION_365174" },
	{ config_id = 1365177, name = "ANY_GADGET_DIE_365177", event = EventType.EVENT_ANY_GADGET_DIE, source = "", condition = "condition_EVENT_ANY_GADGET_DIE_365177", action = "", trigger_count = 0, tag = "888" }
}

-- 变量
variables = {
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 0,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 365142, 365144 },
		regions = { },
		triggers = { "GADGET_CREATE_365002", "SELECT_OPTION_365003", "GADGET_STATE_CHANGE_365110" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = ,
		monsters = { },
		gadgets = { 365001, 365004, 365005, 365006, 365007, 365008, 365009, 365010, 365011, 365013, 365014, 365015, 365016, 365017, 365018, 365019, 365020, 365021, 365022, 365023, 365024, 365025, 365026, 365027, 365052 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = ,
		monsters = { },
		gadgets = { 365028, 365030, 365031, 365033, 365034, 365036, 365037, 365039, 365040, 365042, 365043, 365045, 365047, 365048, 365049, 365051, 365054, 365055, 365056, 365057, 365058, 365059, 365061, 365062, 365063, 365064, 365065, 365066, 365067, 365068, 365069, 365070, 365071, 365072, 365073, 365074, 365075, 365076, 365077, 365078, 365079, 365080, 365081, 365082, 365083, 365084, 365085, 365086, 365087, 365089 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = ,
		monsters = { },
		gadgets = { 365029, 365032, 365038, 365041, 365091, 365092, 365093, 365094, 365097, 365100, 365103, 365118, 365123, 365125, 365126, 365128 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = ,
		monsters = { },
		gadgets = { 365096, 365101, 365102, 365104, 365105, 365106, 365109, 365114, 365116, 365117, 365129, 365130, 365132 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = ,
		monsters = { },
		gadgets = { 365035, 365044, 365107, 365108, 365111, 365113, 365119, 365120, 365121, 365136 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { 365046, 365050, 365172, 365173, 365174 },
		triggers = { "ENTER_REGION_365046", "ENTER_REGION_365050", "CHALLENGE_FAIL_365143", "CHALLENGE_SUCCESS_365145", "ENTER_REGION_365172", "ENTER_REGION_365173", "ENTER_REGION_365174", "ANY_GADGET_DIE_365177" },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 9,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 10,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_CREATE_365002(context, evt)
	if 365142 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_365002(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133004365, 365142, {2}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_365003(context, evt)
	-- 判断是gadgetid 365142 option_id 2
	if 365142 ~= evt.param1 then
		return false	
	end
	
	if 2 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_365003(context, evt)
	-- 将configid为 365144 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 365144, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除指定group： 133004365 ；指定config：365142；物件身上指定option：2；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133004365, 365142, 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133004365, 2)
	
	-- 触发镜头注目，注目位置为坐标（2288，304，-140），持续时间为2秒，并且为强制注目形式，不广播其他玩家
		local pos = {x=2288, y=304, z=-140}
	  local pos_follow = {x=0, y=0, z=0}
	    if 0 ~= ScriptLib.BeginCameraSceneLook(context, { look_pos = pos, is_allow_input = false, duration = 2, is_force = true, is_broadcast = false, is_recover_keep_current = true, delay = 0,
	                                                      is_set_follow_pos = false, follow_pos = pos_follow, is_force_walk = false, is_change_play_mode = false,
	                                                      is_set_screen_XY = false, screen_x = 0, screen_y = 0 }) then
					ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_cameraLook_Begin")
	        return -1
				end 
	
	-- 删除指定group： 133004365 ；指定config：365142；物件身上指定option：2；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133004365, 365142, 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_365046(context, evt)
	if evt.param1 ~= 365046 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_365046(context, evt)
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133004365, 5)
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365106) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365109) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365114) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365116) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365117) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365101) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_365050(context, evt)
	if evt.param1 ~= 365050 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_365050(context, evt)
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133004365, 6)
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365119) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365120) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365121) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365113) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_365110(context, evt)
	if 365144 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_365110(context, evt)
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133004365, 7)
	
	-- 创建编号为666（该挑战的识别id),挑战内容为127的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	ScriptLib.CreateFatherChallenge(context, 2008, 2008, 191, {success = 1, fail = 1})
	ScriptLib.AttachChildChallenge(context, 2008, 2009, 2009,{0,4, 666,1},{},{success=1,fail=1})
	ScriptLib.AttachChildChallenge(context, 2008, 2010, 2010,{0,2, 888,5},{},{success=0,fail=0})
	ScriptLib.StartFatherChallenge(context, 2008)
	ScriptLib.SetChallengeEventMark(context, 2008, ChallengeEventMarkType.FLIGHT_TIME)
	ScriptLib.SetChallengeEventMark(context, 2010, ChallengeEventMarkType.FLIGHT_GATHER_POINT)
	
	
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133004365, 2)
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_365143(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133004365, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_365145(context, evt)
		-- 重新生成指定group，指定suite
		if 0 ~= ScriptLib.RefreshGroup(context, { group_id = 133004365, suite = 1 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : refresh_group_to_suite")
			return -1
		end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_365172(context, evt)
	if evt.param1 ~= 365172 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_365173(context, evt)
	if evt.param1 ~= 365173 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_365173(context, evt)
	-- 添加suite3的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133004365, 3)
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365047) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365048) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365049) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365051) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365054) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365055) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365056) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_365174(context, evt)
	if evt.param1 ~= 365174 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_365174(context, evt)
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133004365, 4)
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133004365, 2)
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365118) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365103) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365100) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365097) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365094) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	-- 启动移动平台
	if 0 ~= ScriptLib.StartPlatform(context, 365091) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : start_platform")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_ANY_GADGET_DIE_365177(context, evt)
	if (365007 == evt.param1)  or (365033 == evt.param1) or (365113 == evt.param1) or (365101 == evt.param1) or (365029 == evt.param1) then
	    return true
	end
	
	return false
end

require "FlyChallenge"