-- 基础信息
local base_info = {
	group_id = 133101247
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 247001, monster_id = 20011201, pos = { x = 1436.191, y = 230.961, z = 1217.624 }, rot = { x = 0.000, y = 154.794, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247002, monster_id = 20011201, pos = { x = 1433.595, y = 230.531, z = 1211.932 }, rot = { x = 0.000, y = 154.794, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247003, monster_id = 20011301, pos = { x = 1439.977, y = 230.348, z = 1211.557 }, rot = { x = 0.000, y = 199.772, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247030, monster_id = 20011101, pos = { x = 1433.573, y = 230.759, z = 1216.063 }, rot = { x = 0.000, y = 113.268, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247032, monster_id = 20011001, pos = { x = 1435.337, y = 230.222, z = 1209.689 }, rot = { x = 0.000, y = 113.268, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247034, monster_id = 20011001, pos = { x = 1440.982, y = 230.704, z = 1214.180 }, rot = { x = 0.000, y = 158.246, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247036, monster_id = 20010501, pos = { x = 1435.685, y = 230.241, z = 1210.233 }, rot = { x = 0.000, y = 279.020, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247037, monster_id = 20010501, pos = { x = 1435.408, y = 230.882, z = 1215.823 }, rot = { x = 0.000, y = 234.042, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247038, monster_id = 20010601, pos = { x = 1440.001, y = 230.770, z = 1214.403 }, rot = { x = 0.000, y = 234.042, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247039, monster_id = 20010901, pos = { x = 1436.880, y = 230.993, z = 1217.003 }, rot = { x = 0.000, y = 74.056, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247040, monster_id = 20010801, pos = { x = 1439.489, y = 230.399, z = 1212.054 }, rot = { x = 0.000, y = 29.078, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247041, monster_id = 20010801, pos = { x = 1434.724, y = 230.366, z = 1211.402 }, rot = { x = 0.000, y = 29.078, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247042, monster_id = 20011401, pos = { x = 1438.219, y = 230.245, z = 1210.168 }, rot = { x = 0.000, y = 236.865, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247043, monster_id = 20011501, pos = { x = 1434.260, y = 230.628, z = 1214.128 }, rot = { x = 0.000, y = 191.887, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 },
	{ config_id = 247044, monster_id = 20011401, pos = { x = 1438.618, y = 230.887, z = 1216.159 }, rot = { x = 0.000, y = 191.887, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 5 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 247004, gadget_id = 70690006, pos = { x = 1462.893, y = 285.560, z = 1223.595 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247005, gadget_id = 70310013, pos = { x = 1448.516, y = 310.160, z = 1205.845 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247006, gadget_id = 70690006, pos = { x = 1431.742, y = 228.549, z = 1221.420 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247007, gadget_id = 70360025, pos = { x = 1448.535, y = 310.871, z = 1205.927 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247008, gadget_id = 70350085, pos = { x = 1451.864, y = 244.182, z = 1216.852 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247009, gadget_id = 70220042, pos = { x = 1437.601, y = 230.919, z = 1215.961 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247010, gadget_id = 70350085, pos = { x = 1448.312, y = 268.830, z = 1233.823 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247011, gadget_id = 70360001, pos = { x = 1437.328, y = 231.673, z = 1214.023 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, persistent = true, area_id = 5 },
	{ config_id = 247012, gadget_id = 70350085, pos = { x = 1462.313, y = 290.726, z = 1225.558 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247014, gadget_id = 70350085, pos = { x = 1448.535, y = 310.871, z = 1205.927 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247015, gadget_id = 70690006, pos = { x = 1447.245, y = 256.266, z = 1239.423 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247016, gadget_id = 70710126, pos = { x = 1451.864, y = 244.182, z = 1216.852 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247017, gadget_id = 70710126, pos = { x = 1448.312, y = 268.830, z = 1233.823 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247018, gadget_id = 70710126, pos = { x = 1462.313, y = 290.726, z = 1225.558 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247019, gadget_id = 70690006, pos = { x = 1456.814, y = 243.158, z = 1215.678 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247022, gadget_id = 70310013, pos = { x = 1451.641, y = 243.158, z = 1216.907 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247023, gadget_id = 70310013, pos = { x = 1448.184, y = 268.119, z = 1234.066 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247024, gadget_id = 70310013, pos = { x = 1462.111, y = 290.015, z = 1225.766 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 5 },
	{ config_id = 247026, gadget_id = 70350083, pos = { x = 1437.330, y = 230.650, z = 1213.898 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, persistent = true, area_id = 5 }
}

-- 区域
regions = {
	{ config_id = 247028, shape = RegionShape.SPHERE, radius = 2, pos = { x = 1448.535, y = 310.482, z = 1205.927 }, area_id = 5 },
	{ config_id = 247029, shape = RegionShape.SPHERE, radius = 2, pos = { x = 1451.953, y = 243.793, z = 1216.623 }, area_id = 5 },
	{ config_id = 247031, shape = RegionShape.SPHERE, radius = 2, pos = { x = 1448.312, y = 268.441, z = 1233.823 }, area_id = 5 },
	{ config_id = 247033, shape = RegionShape.SPHERE, radius = 2, pos = { x = 1462.645, y = 290.754, z = 1225.970 }, area_id = 5 }
}

-- 触发器
triggers = {
	{ config_id = 1247013, name = "GADGET_CREATE_247013", event = EventType.EVENT_GADGET_CREATE, source = "", condition = "condition_EVENT_GADGET_CREATE_247013", action = "action_EVENT_GADGET_CREATE_247013", trigger_count = 0 },
	{ config_id = 1247020, name = "CHALLENGE_SUCCESS_247020", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "874", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_247020" },
	{ config_id = 1247021, name = "CHALLENGE_FAIL_247021", event = EventType.EVENT_CHALLENGE_FAIL, source = "874", condition = "", action = "action_EVENT_CHALLENGE_FAIL_247021", trigger_count = 0 },
	{ config_id = 1247025, name = "SELECT_OPTION_247025", event = EventType.EVENT_SELECT_OPTION, source = "", condition = "condition_EVENT_SELECT_OPTION_247025", action = "action_EVENT_SELECT_OPTION_247025", trigger_count = 0 },
	{ config_id = 1247027, name = "GADGET_STATE_CHANGE_247027", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_247027", action = "action_EVENT_GADGET_STATE_CHANGE_247027", trigger_count = 0 },
	{ config_id = 1247028, name = "ENTER_REGION_247028", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_247028", action = "", trigger_count = 0, tag = "888" },
	{ config_id = 1247029, name = "ENTER_REGION_247029", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_247029", action = "action_EVENT_ENTER_REGION_247029" },
	{ config_id = 1247031, name = "ENTER_REGION_247031", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_247031", action = "action_EVENT_ENTER_REGION_247031" },
	{ config_id = 1247033, name = "ENTER_REGION_247033", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_247033", action = "action_EVENT_ENTER_REGION_247033" }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasStarted", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 8,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = 起点,
		monsters = { },
		gadgets = { 247011, 247026 },
		regions = { },
		triggers = { "GADGET_CREATE_247013", "CHALLENGE_SUCCESS_247020", "CHALLENGE_FAIL_247021", "SELECT_OPTION_247025" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = 终点,
		monsters = { },
		gadgets = { 247005, 247007 },
		regions = { 247028 },
		triggers = { "ENTER_REGION_247028" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = 事件完成空Suite,
		monsters = { },
		gadgets = { 247026 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 4,
		-- description = 节点1,
		monsters = { },
		gadgets = { 247006, 247008, 247016, 247022 },
		regions = { 247029 },
		triggers = { "ENTER_REGION_247029" },
		rand_weight = 100
	},
	{
		-- suite_id = 5,
		-- description = 节点2,
		monsters = { },
		gadgets = { 247010, 247017, 247019, 247023 },
		regions = { 247031 },
		triggers = { "ENTER_REGION_247031" },
		rand_weight = 100
	},
	{
		-- suite_id = 6,
		-- description = 节点3,
		monsters = { },
		gadgets = { 247012, 247015, 247018, 247024 },
		regions = { 247033 },
		triggers = { "ENTER_REGION_247033" },
		rand_weight = 100
	},
	{
		-- suite_id = 7,
		-- description = ,
		monsters = { },
		gadgets = { 247004, 247014 },
		regions = { },
		triggers = { },
		rand_weight = 100
	},
	{
		-- suite_id = 8,
		-- description = ,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_247027" },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_GADGET_CREATE_247013(context, evt)
	if 247011 ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_CREATE_247013(context, evt)
	-- 设置操作台选项
	if 0 ~= ScriptLib.SetWorktopOptionsByGroupId(context, 133101247, 247011, {40}) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_wok_options_by_configid")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_247020(context, evt)
	-- 将configid为 247026 的物件更改为状态 GadgetState.GearStop
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 247026, GadgetState.GearStop) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 2)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 7)
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133101247, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	--销毁编号为1（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133101247, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_247021(context, evt)
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 2)
	
	-- 删除suite4的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 4)
	
	-- 删除suite5的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 5)
	
	-- 删除suite6的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 6)
	
	-- 删除suite7的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133101247, 7)
	
	-- 将configid为 247026 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 247026, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建id为247011的gadget
	if 0 ~= ScriptLib.CreateGadget(context, { config_id = 247011 }) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : create_gadget")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	--销毁编号为1（该怪物潮的识别id)的怪物潮
	if 0 ~= ScriptLib.KillMonsterTide(context, 133101247, 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_monster_tide")
		return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_SELECT_OPTION_247025(context, evt)
	-- 判断是gadgetid 247011 option_id 40
	if 247011 ~= evt.param1 then
		return false	
	end
	
	if 40 ~= evt.param2 then
		return false
	end
	
	
	return true
end

-- 触发操作
function action_EVENT_SELECT_OPTION_247025(context, evt)
	-- 删除指定group： 133101247 ；指定config：247011；物件身上指定option：40；
	if 0 ~= ScriptLib.DelWorktopOptionByGroupId(context, 133101247, 247011, 40) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : del_work_options_by_group_configId")
		return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247011 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 将configid为 247026 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 247026, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建编号为874（该挑战的识别id),挑战内容为205的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 874, 205, 20, 4, 888, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133101247, 2)
	
	-- 将本组内变量名为 "hasStarted" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasStarted", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	-- 创建编号为1（该怪物潮的识别id)的怪物潮，创建怪物总数为15，场上怪物最少3只，最多3只
	if 0 ~= ScriptLib.AutoMonsterTide(context, 1, 133101247, {247034,247032,247030,247002,247001,247003,247036,247037,247038,247040,247041,247039,247042,247044,247043}, 15, 3, 3) then
		return -1
	end
	
	-- 添加suite4的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133101247, 4)
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_247027(context, evt)
	if 247009 ~= evt.param2 or GadgetState.ChestOpened ~= evt.param1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_247027(context, evt)
	-- 添加suite1的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133101247, 1)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_247028(context, evt)
	if evt.param1 ~= 247028 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发条件
function condition_EVENT_ENTER_REGION_247029(context, evt)
	if evt.param1 ~= 247029 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_247029(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247008 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247016 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite5的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133101247, 5)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_247031(context, evt)
	if evt.param1 ~= 247031 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_247031(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247010 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247017 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite6的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133101247, 6)
	
	return 0
end

-- 触发条件
function condition_EVENT_ENTER_REGION_247033(context, evt)
	if evt.param1 ~= 247033 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_247033(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247012 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 247018 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 添加suite7的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133101247, 7)
	
	return 0
end

require "TreasureMapEvent"