-- 基础信息
local base_info = {
	group_id = 133104421
}

--================================================================
-- 
-- 配置
-- 
--================================================================

-- 怪物
monsters = {
	{ config_id = 421001, monster_id = 20011201, pos = { x = 68.655, y = 208.587, z = 697.394 }, rot = { x = 0.000, y = 1.831, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421002, monster_id = 20011201, pos = { x = 67.181, y = 208.624, z = 694.925 }, rot = { x = 0.000, y = 351.827, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421003, monster_id = 20011401, pos = { x = 87.049, y = 208.037, z = 674.591 }, rot = { x = 0.000, y = 351.209, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421012, monster_id = 20011401, pos = { x = 89.681, y = 207.442, z = 673.406 }, rot = { x = 0.000, y = 359.222, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421013, monster_id = 20011001, pos = { x = 107.833, y = 202.153, z = 638.478 }, rot = { x = 0.000, y = 14.733, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421014, monster_id = 20011001, pos = { x = 108.401, y = 202.072, z = 635.803 }, rot = { x = 0.000, y = 357.851, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421015, monster_id = 20010801, pos = { x = 102.946, y = 200.269, z = 587.611 }, rot = { x = 10.402, y = 0.103, z = 1.133 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421016, monster_id = 20010801, pos = { x = 102.130, y = 200.204, z = 589.558 }, rot = { x = 0.000, y = 339.567, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421018, monster_id = 20011201, pos = { x = 70.444, y = 208.454, z = 694.894 }, rot = { x = 0.000, y = 321.404, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421019, monster_id = 20010501, pos = { x = 103.239, y = 201.621, z = 620.178 }, rot = { x = 0.000, y = 357.851, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421020, monster_id = 20011001, pos = { x = 105.417, y = 202.261, z = 638.365 }, rot = { x = 0.000, y = 14.733, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421021, monster_id = 20011001, pos = { x = 105.676, y = 202.208, z = 635.617 }, rot = { x = 0.000, y = 357.851, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421022, monster_id = 20010501, pos = { x = 104.337, y = 201.050, z = 617.191 }, rot = { x = 0.000, y = 357.851, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421023, monster_id = 20010501, pos = { x = 102.000, y = 201.391, z = 617.781 }, rot = { x = 0.000, y = 357.851, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421024, monster_id = 20010801, pos = { x = 104.797, y = 200.230, z = 588.054 }, rot = { x = 0.000, y = 1.122, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 },
	{ config_id = 421027, monster_id = 20011401, pos = { x = 86.520, y = 208.244, z = 671.962 }, rot = { x = 0.000, y = 359.222, z = 0.000 }, level = 1, drop_id = 1000100, disableWander = true, affix = { 1410 }, area_id = 9 }
}

-- NPC
npcs = {
}

-- 装置
gadgets = {
	{ config_id = 421004, gadget_id = 70360005, pos = { x = 66.647, y = 210.341, z = 724.108 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 421005, gadget_id = 70360025, pos = { x = 105.159, y = 201.354, z = 553.209 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 421006, gadget_id = 70350085, pos = { x = 105.159, y = 201.354, z = 553.209 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 },
	{ config_id = 421007, gadget_id = 70350085, pos = { x = 66.650, y = 210.757, z = 724.154 }, rot = { x = 0.000, y = 0.000, z = 0.000 }, level = 1, area_id = 9 }
}

-- 区域
regions = {
	{ config_id = 421008, shape = RegionShape.SPHERE, radius = 3, pos = { x = 105.159, y = 201.354, z = 553.209 }, area_id = 9 }
}

-- 触发器
triggers = {
	{ config_id = 1421008, name = "ENTER_REGION_421008", event = EventType.EVENT_ENTER_REGION, source = "", condition = "condition_EVENT_ENTER_REGION_421008", action = "action_EVENT_ENTER_REGION_421008", tag = "666", forbid_guest = false },
	{ config_id = 1421009, name = "CHALLENGE_SUCCESS_421009", event = EventType.EVENT_CHALLENGE_SUCCESS, source = "888", condition = "", action = "action_EVENT_CHALLENGE_SUCCESS_421009", trigger_count = 0 },
	{ config_id = 1421010, name = "CHALLENGE_FAIL_421010", event = EventType.EVENT_CHALLENGE_FAIL, source = "888", condition = "", action = "action_EVENT_CHALLENGE_FAIL_421010", trigger_count = 0 },
	{ config_id = 1421011, name = "GADGET_STATE_CHANGE_421011", event = EventType.EVENT_GADGET_STATE_CHANGE, source = "", condition = "condition_EVENT_GADGET_STATE_CHANGE_421011", action = "action_EVENT_GADGET_STATE_CHANGE_421011", trigger_count = 0 }
}

-- 变量
variables = {
	{ config_id = 1, name = "hasFinished", value = 0, no_refresh = false }
}

--================================================================
-- 
-- 初始化配置
-- 
--================================================================

-- 初始化时创建
init_config = {
	suite = 1,
	end_suite = 3,
	rand_suite = false
}

--================================================================
-- 
-- 小组配置
-- 
--================================================================

suites = {
	{
		-- suite_id = 1,
		-- description = ,
		monsters = { },
		gadgets = { 421004, 421007 },
		regions = { },
		triggers = { "GADGET_STATE_CHANGE_421011" },
		rand_weight = 100
	},
	{
		-- suite_id = 2,
		-- description = suite_2,
		monsters = { 421001, 421002, 421003, 421012, 421013, 421014, 421015, 421016, 421018, 421019, 421020, 421021, 421022, 421023, 421024, 421027 },
		gadgets = { 421005, 421006 },
		regions = { 421008 },
		triggers = { "ENTER_REGION_421008", "CHALLENGE_SUCCESS_421009", "CHALLENGE_FAIL_421010" },
		rand_weight = 100
	},
	{
		-- suite_id = 3,
		-- description = suite_3,
		monsters = { },
		gadgets = { },
		regions = { },
		triggers = { },
		rand_weight = 100
	}
}

--================================================================
-- 
-- 触发器
-- 
--================================================================

-- 触发条件
function condition_EVENT_ENTER_REGION_421008(context, evt)
	if evt.param1 ~= 421008 then return false end
	
	-- 判断角色数量不少于1
	if ScriptLib.GetRegionEntityCount(context, { region_eid = evt.source_eid, entity_type = EntityType.AVATAR }) < 1 then
		return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_ENTER_REGION_421008(context, evt)
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 421005 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_SUCCESS_421009(context, evt)
	-- 将本组内变量名为 "hasFinished" 的变量设置为 1
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 1) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
		-- 永久关闭CongfigId的Gadget，需要和Groups的RefreshWithBlock标签搭配
		if 0 ~= ScriptLib.KillEntityByConfigId(context, { config_id = 421007 }) then
	    ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : kill_entity_by_configId")
		    return -1
		end
		
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133104421, 2)
	
	-- 将configid为 421004 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 421004, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- group调整group进度,只对非randSuite有效
	if 0 ~= ScriptLib.GoToGroupSuite(context, 133104421, 3) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : goto_groupSuite")
		return -1
	end
	
	return 0
end

-- 触发操作
function action_EVENT_CHALLENGE_FAIL_421010(context, evt)
	-- 将configid为 421007 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 421007, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 删除suite2的所有内容
	    ScriptLib.RemoveExtraGroupSuite(context, 133104421, 2)
	
	-- 将configid为 421004 的物件更改为状态 GadgetState.Default
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 421004, GadgetState.Default) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 将本组内变量名为 "hasFinished" 的变量设置为 0
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 0) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end

-- 触发条件
function condition_EVENT_GADGET_STATE_CHANGE_421011(context, evt)
	if 421004 ~= evt.param2 or GadgetState.GearStart ~= evt.param1 then
		return false
	end
	
	-- 判断变量"hasFinished"为0
	if ScriptLib.GetGroupVariableValue(context, "hasFinished") ~= 0 then
			return false
	end
	
	return true
end

-- 触发操作
function action_EVENT_GADGET_STATE_CHANGE_421011(context, evt)
	-- 添加suite2的新内容
	    ScriptLib.AddExtraGroupSuite(context, 133104421, 2)
	
	-- 将configid为 421007 的物件更改为状态 GadgetState.GearStart
	if 0 ~= ScriptLib.SetGadgetStateByConfigId(context, 421007, GadgetState.GearStart) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_gadget_state_by_configId")
			return -1
		end 
	
	-- 创建编号为888（该挑战的识别id),挑战内容为189的区域挑战，具体参数填写方式，见DungeonChallengeData表中的注释，所有填写的值都必须是int类型
	if 0 ~= ScriptLib.ActiveChallenge(context, 888, 189, 25, 4, 666, 5) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : active_challenge")
		return -1
	end
	
	-- 将本组内变量名为 "hasFinished" 的变量设置为 2
	if 0 ~= ScriptLib.SetGroupVariableValue(context, "hasFinished", 2) then
	  ScriptLib.PrintContextLog(context, "@@ LUA_WARNING : set_groupVariable")
	  return -1
	end
	
	return 0
end